/*
 * Application.h
 *
 *  Created on: 18.07.2011
 *      Author: stefan.detter
 */

#ifndef APPLICATION_H_
#define APPLICATION_H_

#include <QObject>
#include <QMap>
#include <QrfeTraceModule>

#include <def.h>

class QrfeReaderManager;
class QrfeReaderInterface;

class Reader;

class Application : public QObject, QrfeTraceModule
{
	Q_OBJECT

public:
	Application(QrfeReaderManager* manager, QObject* parent = 0);
	virtual ~Application();

	QrfeReaderManager*		readerManager() const;
	QList<QString>			readerList() const;
	Reader*					reader(QString readerId) const;

signals:
	void readerAttached ( Reader* reader );
	void readerLost();
    void appendGlobalJob(JobType type, const QList<QVariant>& params);

private slots:
	void readerAttachedSlot ( QrfeReaderInterface* reader );
	void readerLostConnectionSlot();
	void readerDeleteRequestSlot();

private:
	QrfeReaderManager* 			m_manager;
	QMap<QString, Reader*>		m_reader;
	QList<Reader*>				m_toDelete;
};

#endif /* APPLICATION_H_ */
